package gov.va.vinci.dart.json.builder;

//import gov.va.vinci.dart.biz.Comment;
import gov.va.vinci.dart.biz.NestableComment;
import gov.va.vinci.dart.json.CommentListView;
//import gov.va.vinci.dart.json.CommentReplyView;
import gov.va.vinci.dart.json.CommentView;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommentListViewBuilder {

	private CommentViewBuilder commentViewBuilder = new CommentViewBuilder();
	
	/**
	 * Returns a list of the parentId values (for the entire parent chain) for the specified comment.
	 * Used by the UI (for indentation and show/collapse of the comments).
	 * 
	 * @param commentHash
	 * @param commentId
	 * @return
	 */
	private static List<Integer> getParentList( final Map<Integer, CommentView> commentHash, final Integer commentId ) {
		
		List<Integer> parentList = new ArrayList<Integer>();

		CommentView currentComment = commentHash.get( commentId );
		while( currentComment != null && currentComment.getCommentId() != currentComment.getParentId() ) {
			parentList.add( currentComment.getParentId() );	//add this parent to the list
			
			//move to parent
			currentComment = commentHash.get( currentComment.getParentId() );
		}
		
		return parentList;
	}
	
	
	// build a DTO from a business object list
	public CommentListView build(final List<NestableComment> list) {
	
		CommentListView result = new CommentListView();
		
		if (list == null || list.size() < 1) {
			return result;
		}
		
//testing -- (updated to match the CommunicationController and comment structure)
//		CommentView lastParent = null;
//		
//		for (NestableComment nestable : list) {
//			
//			if ("Parent".equals(nestable.getRelation())) {
//				CommentView view = new CommentViewBuilder().build(nestable);
//
//				result.getComments().add(view);
//				lastParent = view;
//			}
//			else {
//				CommentReplyView view = new CommentReplyViewBuilder().build(nestable);
//
//				lastParent.getReplies().add(view);
//			}
//		}

		Map<Integer, CommentView> commentHash = new HashMap<Integer, CommentView>();	//commentId
		
		for (NestableComment nestable : list) {

			CommentView view = commentViewBuilder.build(nestable);
			commentHash.put( nestable.getId(), view );	//keep the comment so that we can add the replies in the appropriate spot
			
			//if this is a new parent comment, add it to the result
			if( nestable.getId() == nestable.getParentId() ) {
				result.getComments().add(view);
			} 
			else {
				
				//add this reply to the appropriate parent comment
				CommentView parentComment = commentHash.get( nestable.getParentId() );
				if( parentComment != null ) {
					parentComment.getReplies().add( view );
				}
			}
		}
						
		//create the list of parents for this comment (used by the UI)				
		for( Integer currCommentId : commentHash.keySet() ) {
			CommentView currCommentView = commentHash.get( currCommentId );
			if( currCommentView != null )  {
				List<Integer> parentList = getParentList( commentHash, currCommentView.getCommentId() );
				Collections.sort(parentList);
				
				currCommentView.getParents().addAll( parentList );
			}//end if
		}
		
		
		return result;
	}	
}
